"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDefinition = exports.deleteSizeById = exports.getSizeDefinationById = exports.getAllSizeDefinations = exports.createSizeDefination = void 0;
const size_defination_1 = require("../models/size_defination");
/// Create a new size definition
const createSizeDefination = async (req, res) => {
    // 1. Validate the request body
    const { error } = size_defination_1.sizeDefinationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        // 2. Check if a size with this number already exists
        let sizeDef = await size_defination_1.SizeDefinationModel.findOne({
            where: { sizeNumber: req.body.sizeNumber, gender: req.body.gender },
        });
        if (sizeDef)
            return res.status(400).json({ error: "Size number already exists." });
        // 3. Create and save the new size definition
        sizeDef = new size_defination_1.SizeDefinationModel(req.body);
        await sizeDef.save();
        // 4. Send success response
        res.status(200).json({
            message: "Size definition created successfully.",
            id: sizeDef.id,
        });
    }
    catch (ex) {
        res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.createSizeDefination = createSizeDefination;
/// Get all size definitions
const getAllSizeDefinations = async (req, res) => {
    try {
        const sizeDefinitions = await size_defination_1.SizeDefinationModel.findAll();
        const response = sizeDefinitions.map((item) => {
            return Object.assign(Object.assign({}, item.toJSON()), { upperWear: JSON.parse(item.upperWear.toString()), lowerWear: JSON.parse(item.lowerWear.toString()), headCover: item.headCover
                    ? JSON.parse(item.headCover.toString())
                    : null });
        });
        res.status(200).json(response);
    }
    catch (ex) {
        res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.getAllSizeDefinations = getAllSizeDefinations;
/// Get a single size definition by ID
const getSizeDefinationById = async (req, res) => {
    try {
        const sizeDefinition = await size_defination_1.SizeDefinationModel.findByPk(req.params.id);
        if (!sizeDefinition)
            return res.status(404).json({ error: "Size definition not found." });
        res.status(200).json(sizeDefinition);
    }
    catch (ex) {
        res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.getSizeDefinationById = getSizeDefinationById;
/// Delete size definition by ID
const deleteSizeById = async (req, res) => {
    const deleteCount = await size_defination_1.SizeDefinationModel.destroy({
        where: { id: req.params.id },
    });
    if (deleteCount === 0)
        return res.status(400).json({ Error: "Size not found" });
    return res.status(200).json({ message: "Size deleted successfully" });
};
exports.deleteSizeById = deleteSizeById;
/// Update definition
const updateDefinition = async (req, res) => {
    const sizeDef = await size_defination_1.SizeDefinationModel.findByPk(req.params.id);
    if (!sizeDef)
        return res.status(400).json({ Error: "No definittion found of this ID" });
    const findData = await size_defination_1.SizeDefinationModel.findOne({
        where: { sizeNumber: req.body.sizeNumber, gender: req.body.gender },
    });
    if (findData)
        return res.status(400).json({ error: "Size already exits" });
    await sizeDef.update(req.body);
    return res
        .status(200)
        .json({ message: "Size definition updated successfully" });
};
exports.updateDefinition = updateDefinition;
