"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteShopProduct = exports.updateShopProduct = exports.getAllShopProducts = exports.createShopProduct = void 0;
const shop_product_1 = require("../models/shop_product");
/// Create new shop product
const createShopProduct = async (req, res) => {
    const { error } = shop_product_1.shopProductValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const newShopProduct = await shop_product_1.ShopProductModel.create(req.body);
        return res
            .status(200)
            .json({
            message: "Shop product created successfully.",
            id: newShopProduct.id,
        });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.createShopProduct = createShopProduct;
/// Get all shop products
const getAllShopProducts = async (req, res) => {
    try {
        const shopProducts = await shop_product_1.ShopProductModel.findAll({
            where: { isDeleted: false },
        });
        return res.status(200).json(shopProducts);
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.getAllShopProducts = getAllShopProducts;
/// Update existing shop product
const updateShopProduct = async (req, res) => {
    try {
        // Find the shop product by ID
        const shopProduct = await shop_product_1.ShopProductModel.findByPk(req.params.id);
        if (!shopProduct)
            return res.status(404).json({ error: "Shop product not found." });
        // Validate the request body
        const { error } = shop_product_1.shopProductValidationSchema.validate(req.body);
        if (error)
            return res.status(400).json({ error: error.details[0].message });
        // Update the shop product details
        await shopProduct.update(req.body);
        // Send success response
        return res
            .status(200)
            .json({
            message: "Shop product updated successfully.",
            id: shopProduct.id,
        });
    }
    catch (ex) {
        console.error(`Error updating shop product: ${ex}`);
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.updateShopProduct = updateShopProduct;
/// Delete a shop product
const deleteShopProduct = async (req, res) => {
    try {
        // Find the shop product by ID
        const shopProduct = await shop_product_1.ShopProductModel.findByPk(req.params.id);
        if (!shopProduct)
            return res.status(404).json({ error: "Shop product not found." });
        // Soft delete the shop product
        await shopProduct.update({ isDeleted: true });
        // Send success response
        return res
            .status(200)
            .json({ message: "Shop product deleted successfully." });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.deleteShopProduct = deleteShopProduct;
