"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteShop = exports.updateShop = exports.getAllShops = exports.createShop = void 0;
const shop_1 = require("../models/shop");
/// Create new shop
const createShop = async (req, res) => {
    const { error } = shop_1.shopValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const newShop = await shop_1.ShopModel.create(req.body);
        return res
            .status(200)
            .json({ message: "Shop created successfully.", id: newShop.id });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.createShop = createShop;
/// Get all shops
const getAllShops = async (req, res) => {
    try {
        const shops = await shop_1.ShopModel.findAll({
            where: { isDeleted: false },
        });
        return res.status(200).json(shops);
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.getAllShops = getAllShops;
/// Update existing shop
const updateShop = async (req, res) => {
    try {
        // Find the shop by ID
        const shop = await shop_1.ShopModel.findByPk(req.params.id);
        if (!shop)
            return res.status(404).json({ error: "Shop not found." });
        // Validate the request body
        const { error } = shop_1.shopValidationSchema.validate(req.body);
        if (error)
            return res.status(400).json({ error: error.details[0].message });
        // Update the shop details
        await shop.update(req.body);
        // Send success response
        return res
            .status(200)
            .json({ message: "Shop updated successfully.", id: shop.id });
    }
    catch (ex) {
        console.error(`Error updating shop: ${ex}`);
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.updateShop = updateShop;
/// Delete a shop
const deleteShop = async (req, res) => {
    try {
        // Find the shop by ID
        const shop = await shop_1.ShopModel.findByPk(req.params.id);
        if (!shop)
            return res.status(404).json({ error: "Shop not found." });
        // Soft delete the shop
        await shop.update({ isDeleted: true });
        // Send success response
        return res.status(200).json({ message: "Shop deleted successfully." });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.deleteShop = deleteShop;
