"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteSession = exports.updateSession = exports.getAllSessions = exports.createSession = void 0;
const session_1 = require("../models/session");
/// Create new session
const createSession = async (req, res) => {
    console.log("Request Body:", req.body); // Debugging line
    const { error } = session_1.sessionValidationSchema.validate(req.body);
    if (error) {
        return res.status(400).json({ error: error.details[0].message });
    }
    try {
        const session = await session_1.SessionModel.create(req.body);
        res
            .status(200)
            .json({ messae: "Session created successfully", id: session.id });
    }
    catch (err) {
        return res.status(500).json({ error: "Internal Server Error" });
    }
};
exports.createSession = createSession;
/// Get all sessions
const getAllSessions = async (req, res) => {
    try {
        const sessions = await session_1.SessionModel.findAll({
            where: { isDeleted: 0, classId: req.params.id },
        });
        return res.status(200).json(sessions);
    }
    catch (err) {
        return res.status(500).json({ error: "Internal server error" });
    }
};
exports.getAllSessions = getAllSessions;
const updateSession = async (req, res) => {
    try {
        const session = await session_1.SessionModel.findByPk(req.params.id);
        if (!session)
            return res.status(404).json({ error: "Session not found." });
        const { error } = session_1.updateSessionValidationSchema.validate(req.body, {
            allowUnknown: true,
        });
        if (error)
            return res.status(400).json({ error: error.details[0].message });
        await session.update(req.body);
        res
            .status(200)
            .json({ message: "Session updated successfully.", data: session });
    }
    catch (ex) {
        console.error(ex);
        res.status(500).json({ error: "Internal server error" });
    }
};
exports.updateSession = updateSession;
/// Delete session
const deleteSession = async (req, res) => {
    try {
        // Find the session by ID
        const session = await session_1.SessionModel.findByPk(req.params.id);
        if (!session)
            return res.status(404).json({ error: "Session not found." });
        // Soft delete the session
        await session.update({ isDeleted: true });
        // Send success response
        res.status(200).json({ message: "Session deleted successfully." });
    }
    catch (ex) {
        res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.deleteSession = deleteSession;
