"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateOrderDetails = exports.getAllOrderDetails = exports.createOrderDetails = void 0;
const order_details_1 = require("../models/order_details");
/// Create order details
const createOrderDetails = async (req, res) => {
    const { error } = order_details_1.OrderDetailsValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const orderDetails = await order_details_1.OrderDetails.create(req.body);
        return res
            .status(200)
            .json({
            message: "Order details added successfully",
            id: orderDetails.id,
        });
    }
    catch (err) {
        return res.status(500).json({ error: `Internal server error: ${err}` });
    }
};
exports.createOrderDetails = createOrderDetails;
/// Get all order details
const getAllOrderDetails = async (req, res) => {
    try {
        const orderDetails = await order_details_1.OrderDetails.findAll({
            include: [{ model: require("../models/order").Order, as: "order" }],
        });
        return res.status(200).json({ orderDetails });
    }
    catch (err) {
        return res.status(500).json({ error: `Internal server error: ${err}` });
    }
};
exports.getAllOrderDetails = getAllOrderDetails;
/// Update order details
const updateOrderDetails = async (req, res) => {
    const { error } = order_details_1.OrderDetailsValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const orderDetails = await order_details_1.OrderDetails.findByPk(req.params.id);
        if (!orderDetails)
            return res.status(400).json({ error: "No order details found" });
        const orderDetailsUpdated = await orderDetails.update(req.body);
        return res.status(200).json({ orderDetailsUpdated });
    }
    catch (err) {
        return res.status(500).json({ error: `Internal server error: ${err}` });
    }
};
exports.updateOrderDetails = updateOrderDetails;
