"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteOrder = exports.updateOrder = exports.getAllOrder = exports.createOrder = void 0;
const order_1 = require("../models/order");
/// Create order
const createOrder = async (req, res) => {
    const { error } = order_1.OrderValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const order = await order_1.Order.create(req.body);
        return res
            .status(200)
            .json({ message: "Order added successfully", id: order.id });
    }
    catch (err) {
        return res.status(500).json({ error: `Internal server error: ${err}` });
    }
};
exports.createOrder = createOrder;
/// Get all orders
const getAllOrder = async (req, res) => {
    try {
        const orders = await order_1.Order.findAll({
            where: { isDeleted: 0 },
        });
        return res.status(200).json(orders);
    }
    catch (err) {
        console.log(`Here is error: ${err}`);
        return res.status(500).json({ Error: `Internal server error: ${err}` });
    }
};
exports.getAllOrder = getAllOrder;
/// Update ordr
const updateOrder = async (req, res) => {
    const { error } = order_1.OrderValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ Error: error.details[0].message });
    try {
        const order = await order_1.Order.findByPk(req.params.id);
        if (!order)
            return res.status(400).json({ Error: "No order found" });
        const orderUpdated = await order.update(req.body);
        return res.status(200).json({ orderUpdated });
    }
    catch (err) {
        return res.status(500).json({ Error: `Internal server error: ${err}` });
    }
};
exports.updateOrder = updateOrder;
/// Delete order
const deleteOrder = async (req, res) => {
    try {
        const order = await order_1.Order.findByPk(req.params.id);
        if (!order)
            return res.status(400).json({ Error: "No order found" });
        await order.update({ isDeleted: true });
        return res.status(200).json({ message: "Order deleted successfully." });
    }
    catch (err) {
        return res.status(500).json({ Error: `Internal server error: ${err}` });
    }
};
exports.deleteOrder = deleteOrder;
