"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteClass = exports.updateClass = exports.getAllClasses = exports.createClass = void 0;
const class_1 = require("../models/class");
/// Create new class
const createClass = async (req, res) => {
    const { error } = class_1.classValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const newClass = await class_1.ClassModel.create({
            schoolId: req.body.schoolId,
            name: req.body.name,
            isDeleted: false,
        });
        return res
            .status(200)
            .json({ messsage: "Class added successfully", id: newClass.id });
    }
    catch (err) {
        res.status(500).json({ error: "Internal Server Error" });
    }
};
exports.createClass = createClass;
/// Get all classes
const getAllClasses = async (req, res) => {
    try {
        const classes = await class_1.ClassModel.findAll({
            where: { isDeleted: 0, schoolId: req.params.id },
        });
        res.status(200).json(classes);
    }
    catch (err) {
        res.status(500).json({ error: "Internal Server Error" });
    }
};
exports.getAllClasses = getAllClasses;
const updateClass = async (req, res) => {
    try {
        const classRecord = await class_1.ClassModel.findByPk(req.params.id);
        if (!classRecord)
            return res.status(404).json({ error: "Class not found" });
        const { error } = class_1.classValidationSchema.validate(req.body);
        if (error)
            return res.status(400).json({ error: error.details[0].message });
        await classRecord.update({ name: req.body.name });
        return res.status(200).json({ message: "Class updated successfully" });
    }
    catch (err) {
        console.log(`Error updating class: ${err}`);
        return res.status(500).json({ error: "Internal Server Error" });
    }
};
exports.updateClass = updateClass;
/// Delete a class by ID
const deleteClass = async (req, res) => {
    const classId = req.params.id;
    try {
        const specificClass = await class_1.ClassModel.findByPk(classId);
        if (!specificClass)
            return res.status(404).json({ error: "Class not found" });
        await (specificClass === null || specificClass === void 0 ? void 0 : specificClass.update({ isDeleted: true }));
        res.status(200).json({ message: "Class deleted successfully" });
    }
    catch (err) {
        res.status(500).json({ error: "Internal Server Error" });
    }
};
exports.deleteClass = deleteClass;
