"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteAttendance = exports.updateAttendance = exports.getAllAttendances = exports.createAttendance = void 0;
const attendance_1 = require("../models/attendance");
/// Create new attendance
const createAttendance = async (req, res) => {
    const { error } = attendance_1.attendanceValidationSchema.validate(req.body);
    if (error)
        return res.status(400).json({ error: error.details[0].message });
    try {
        const newAttendance = await attendance_1.AttendanceModel.create(req.body);
        return res
            .status(200)
            .json({
            message: "Attendance created successfully.",
            id: newAttendance.id,
        });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.createAttendance = createAttendance;
/// Get all attendances
const getAllAttendances = async (req, res) => {
    try {
        const attendances = await attendance_1.AttendanceModel.findAll({
            where: { isDeleted: false },
        });
        return res.status(200).json(attendances);
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.getAllAttendances = getAllAttendances;
/// Update existing attendance
const updateAttendance = async (req, res) => {
    try {
        // Find the attendance by ID
        const attendance = await attendance_1.AttendanceModel.findByPk(req.params.id);
        if (!attendance)
            return res.status(404).json({ error: "Attendance not found." });
        // Validate the request body
        const { error } = attendance_1.attendanceValidationSchema.validate(req.body);
        if (error)
            return res.status(400).json({ error: error.details[0].message });
        // Update the attendance details
        await attendance.update(req.body);
        // Send success response
        return res
            .status(200)
            .json({ message: "Attendance updated successfully.", id: attendance.id });
    }
    catch (ex) {
        console.error(`Error updating attendance: ${ex}`);
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.updateAttendance = updateAttendance;
/// Delete an attendance
const deleteAttendance = async (req, res) => {
    try {
        // Find the attendance by ID
        const attendance = await attendance_1.AttendanceModel.findByPk(req.params.id);
        if (!attendance)
            return res.status(404).json({ error: "Attendance not found." });
        // Soft delete the attendance
        await attendance.update({ isDeleted: true });
        // Send success response
        return res
            .status(200)
            .json({ message: "Attendance deleted successfully." });
    }
    catch (ex) {
        return res.status(500).json({ error: "An unexpected error occurred." });
    }
};
exports.deleteAttendance = deleteAttendance;
