"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const helmet_1 = __importDefault(require("helmet"));
const cors_1 = __importDefault(require("cors"));
const multer_1 = __importDefault(require("multer"));
const user_1 = __importDefault(require("./routes/user"));
const size_defination_1 = __importDefault(require("./routes/size_defination"));
const school_1 = __importDefault(require("./routes/school"));
const class_1 = __importDefault(require("./routes/class"));
const session_1 = __importDefault(require("./routes/session"));
const student_1 = __importDefault(require("./routes/student"));
const order_1 = __importDefault(require("./routes/order"));
const order_details_1 = __importDefault(require("./routes/order_details"));
const customer_1 = __importDefault(require("./routes/customer"));
const employee_1 = __importDefault(require("./routes/employee"));
const product_1 = __importDefault(require("./routes/product"));
const purchase_1 = __importDefault(require("./routes/purchase"));
const shop_1 = __importDefault(require("./routes/shop"));
const shop_product_1 = __importDefault(require("./routes/shop_product"));
const user_management_1 = __importDefault(require("./routes/user_management"));
require("./models/associations");
const app = (0, express_1.default)();
const upload = (0, multer_1.default)();
app.use(express_1.default.urlencoded({ extended: true }));
app.use((0, helmet_1.default)());
app.use((0, cors_1.default)({
    origin: "*",
    methods: ["GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"],
    allowedHeaders: ["Content-Type", "Authorization"],
}));
/// USERS
app.use("/api/users", upload.any(), user_1.default);
/// SIZE DEFINITIONS
app.use("/api/sizeDefinitions", upload.any(), size_defination_1.default);
/// SCHOOLS
app.use("/api/schools", school_1.default);
/// CLASSES
app.use("/api/classes", upload.any(), class_1.default);
/// SESSIONS
app.use("/api/sessions", upload.any(), session_1.default);
/// STUDENTS
app.use("/api/students", upload.any(), student_1.default);
/// ORDERS
app.use("/api/orders", upload.any(), order_1.default);
/// ORDER DETAILS
app.use("/api/orderDetails", upload.any(), order_details_1.default);
/// CUSTOMERS
app.use("/api/customers", upload.any(), customer_1.default);
/// EMPLOYEES
app.use("/api/employees", upload.any(), employee_1.default);
/// PRODUCTS
app.use("/api/products", upload.any(), product_1.default);
/// PURCHASES
app.use("/api/purchases", upload.any(), purchase_1.default);
/// SHOPS
app.use("/api/shops", upload.any(), shop_1.default);
/// SHOP PRODUCTS
app.use("/api/shopProducts", upload.any(), shop_product_1.default);
/// USER MANAGEMENT
app.use("/api/userManagement", upload.any(), user_management_1.default);
// Serve uploaded files statically
app.use("/uploads", express_1.default.static("uploads"));
/// 404 Handler
app.use((req, res, next) => {
    let error = new Error("Not Found");
    error.status = 404;
    next(error);
});
app.use((err, req, res, next) => {
    res.status(err.status || 500);
    res.json({
        error: {
            message: err.message,
        },
    });
});
exports.default = app;
