require("dotenv/config");
const mysql = require("mysql2/promise");
const fs = require("fs");

(async () => {
  try {
    const conn = await mysql.createConnection({
      host: process.env.DB_HOST || "localhost",
      user: process.env.DB_USER || "root",
      password: process.env.DB_PASSWORD || undefined,
      database: process.env.DB_NAME || "tuc",
    });

    const sqlFile = fs.readFileSync("./create-addons-table.sql", "utf8");

    console.log("\n🔧 Creating addons table...\n");

    try {
      await conn.execute(sqlFile);
      console.log(`✅ Created table: addons`);
    } catch (err) {
      if (err.code === "ER_TABLE_EXISTS_ERROR") {
        console.log(`⚠️  Table already exists: addons`);
      } else {
        console.error(`❌ Error creating addons: ${err.message}`);
      }
    }

    // Verify the table was created
    const [tables] = await conn.execute("SHOW TABLES");
    console.log(`\n📊 Total tables in database: ${tables.length}`);
    
    // Check if addons table exists
    const [addonCheck] = await conn.execute("SHOW TABLES LIKE 'addons'");
    if (addonCheck.length > 0) {
      console.log("✅ Addons table confirmed in database!");
    } else {
      console.log("❌ Addons table not found in database!");
    }

    await conn.end();
  } catch (error) {
    console.error("❌ Connection Error:", error.message);
    process.exit(1);
  }
})();