require("dotenv/config");
const mysql = require("mysql2/promise");

(async () => {
  try {
    const conn = await mysql.createConnection({
      host: process.env.DB_HOST || "localhost",
      user: process.env.DB_USER || "root",
      password: process.env.DB_PASSWORD || undefined,
      database: process.env.DB_NAME || "tuc",
    });

    console.log("\n📋 Listing all tables in database:\n");

    const [tables] = await conn.execute("SHOW TABLES");
    
    tables.forEach((table, index) => {
      const tableName = Object.values(table)[0];
      console.log(`${index + 1}. ${tableName}`);
    });

    console.log(`\n📊 Total: ${tables.length} tables`);

    // Check specifically for addons
    const [addonCheck] = await conn.execute("SHOW TABLES LIKE 'addons'");
    console.log(`\n🔍 Addons table exists: ${addonCheck.length > 0 ? 'YES' : 'NO'}`);

    await conn.end();
  } catch (error) {
    console.error("❌ Connection Error:", error.message);
    process.exit(1);
  }
})();