# TODO List for Session and Student Models, Controllers, and Routes

## Session Updates

- [x] Update session model: Change to id, name, classId (foreign key). Remove gender, maleUpperWear, maleLowerWear, femaleUpperWear, femaleLowerWear.
- [x] Update session controller: Remove file upload logic, simplify create, update, get, delete functions. Update validation schemas.
- [x] Update session routes: Remove upload middleware from routes.

## Student Creation

- [x] Create student model: id, sessionId (foreign key), name, gender, sizeNumber, upperWear, lowerWear, headcover (null if female).
- [x] Create student controller: Implement CRUD operations (create, getAll, update, delete).
- [x] Create student routes: Define routes for CRUD operations.
- [x] Register student routes in server.ts.

## Customer Creation

- [x] Create customer model: id, name, emailAddress, phoneNumber, address, isDeleted, timestamps.
- [x] Create customer controller: Implement CRUD operations with email uniqueness and soft delete.
- [x] Create customer routes: Define RESTful routes.
- [x] Register customer routes in app.ts.

## Employee Creation

- [x] Create employee model: id, employeeName, email, address, phoneNumber, skills, paymentType (enum), price, isDeleted, timestamps.
- [x] Create employee controller: Implement CRUD operations with email uniqueness and soft delete.
- [x] Create employee routes: Define RESTful routes.
- [x] Register employee routes in app.ts.

## Product Creation

- [x] Create product model: id, productName, productUnit, isDeleted, timestamps.
- [x] Create product controller: Implement CRUD operations with soft delete.
- [x] Create product routes: Define RESTful routes.
- [x] Register product routes in app.ts.

## Purchase Creation

- [x] Create purchase model: id, productId, productName, productUnit, quantity, totalPrice, perUnitPrice, isDeleted, timestamps.
- [x] Create purchase controller: Implement CRUD operations with soft delete.
- [x] Create purchase routes: Define RESTful routes.
- [x] Register purchase routes in app.ts.

## Shop Creation

- [x] Create shop model: id, name, location, number, isDeleted, timestamps.
- [x] Create shop controller: Implement CRUD operations with soft delete.
- [x] Create shop routes: Define RESTful routes.
- [x] Register shop routes in app.ts.

## Shop Product Creation

- [x] Create shop product model: id, shopId, shopName, shopProductName, shopProductUnit, createdAt, updatedAt, isDeleted.
- [x] Create shop product controller: Implement CRUD operations with soft delete.
- [x] Create shop product routes: Define RESTful routes.
- [x] Register shop product routes in app.ts.

## User Management Creation

- [x] Create user management model: id, name, phoneNumber, role (enum: Admin, Shopkeeper, Tailor, Master), hasShopAccess, hasUserAccess, hasOrderAccess, hasSizeDefinitionAccess, isDeleted, timestamps.
- [x] Create user management controller: Implement CRUD operations with soft delete.
- [x] Create user management routes: Define RESTful routes.
- [x] Register user management routes in app.ts.

## Attendance Creation

- [x] Create attendance model: id, employeeId, employeeName, status (enum: Present, Absent, Leave), attendanceDate, isDeleted, timestamps.
- [x] Create attendance controller: Implement CRUD operations with soft delete.
- [x] Create attendance routes: Define RESTful routes.
- [x] Register attendance routes in app.ts.

## Additional Tasks

- [x] Add model associations (Session hasMany Students, Student belongsTo Session).
- [ ] Test the changes if needed.
